#
# Cookbook:: nginx
# Recipe:: naxsi_module
#
# Author:: Artiom Lunev (<artiom.lunev@gmail.com>)
#
# Copyright:: 2012-2017, Artiom Lunev
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

cookbook_file "#{node['nginx']['dir']}/naxsi_core.rules" do
  source 'naxsi_core.rules'
  notifies :reload, 'service[nginx]', :delayed
end

naxsi_src_filename = ::File.basename(node['nginx']['naxsi']['url'])
naxsi_src_filepath = "#{Chef::Config['file_cache_path']}/#{naxsi_src_filename}"
naxsi_extract_path = "#{Chef::Config['file_cache_path']}/nginx-naxsi-#{node['nginx']['naxsi']['version']}"

remote_file naxsi_src_filepath do
  source   node['nginx']['naxsi']['url']
  checksum node['nginx']['naxsi']['checksum']
end

bash 'extract_naxsi_module' do
  cwd  ::File.dirname(naxsi_src_filepath)
  code <<-EOH
    mkdir -p #{naxsi_extract_path}
    tar xzf #{naxsi_src_filename} -C #{naxsi_extract_path}
  EOH
  not_if { ::File.exist?(naxsi_extract_path) }
end

node.run_state['nginx_configure_flags'] =
  node.run_state['nginx_configure_flags'] | ["--add-module=#{naxsi_extract_path}/naxsi-#{node['nginx']['naxsi']['version']}/naxsi_src"]
